package ru.yandex.solomon.alert.domain;

import java.util.Comparator;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public final class LabelsComparator implements Comparator<Labels> {
    public static LabelsComparator INSTANCE = new LabelsComparator();

    @Override
    public int compare(Labels left, Labels right) {
        int result = Integer.compare(left.size(), right.size());
        if (result != 0) {
            return result;
        }

        for (int index = 0; index < left.size(); index++) {
            Label labelLeft = left.at(index);
            Label labelRight = right.at(index);

            result = labelLeft.compareKeys(labelRight);
            if (result != 0) {
                break;
            }

            result = labelLeft.getValue().compareTo(labelRight.getValue());
            if (result != 0) {
                break;
            }
        }

        return result;
    }
}
