package ru.yandex.solomon.alert.domain;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum NoPointsPolicy {
    // Defaults to NO_POINTS_MANUAL for expression and NO_POINTS_NO_DATA for threshold alerts.
    DEFAULT(ru.yandex.solomon.alert.protobuf.NoPointsPolicy.NO_POINTS_DEFAULT.getNumber()),
    // If any of the selectors resolves to nothing, trigger OK immediately.
    // For threshold alerts status is set for a line, for expression - for the whole alert.
    OK(ru.yandex.solomon.alert.protobuf.NoPointsPolicy.NO_POINTS_OK.getNumber()),
    // If any of the selectors resolves to nothing, trigger WARN immediately.
    // For threshold alerts status is set for a line, for expression - for the whole alert.
    WARN(ru.yandex.solomon.alert.protobuf.NoPointsPolicy.NO_POINTS_WARN.getNumber()),
    // If any of the selectors resolves to nothing, trigger ALARM immediately.
    // For threshold alerts status is set for a line, for expression - for the whole alert.
    ALARM(ru.yandex.solomon.alert.protobuf.NoPointsPolicy.NO_POINTS_ALARM.getNumber()),
    // If any of the selectors resolves to nothing, trigger NO_DATA immediately.
    // For threshold alerts status is set for a line, for expression - for the whole alert.
    NO_DATA(ru.yandex.solomon.alert.protobuf.NoPointsPolicy.NO_POINTS_NO_DATA.getNumber()),
    // Process timeseries as is.
    MANUAL(ru.yandex.solomon.alert.protobuf.NoPointsPolicy.NO_POINTS_MANUAL.getNumber()),
    ;

    private final int number;

    NoPointsPolicy(int number) {
        this.number = number;
    }

    public static NoPointsPolicy forNumber(int num) {
        for (NoPointsPolicy policy : values()) {
            if (policy.getNumber() == num) {
                return policy;
            }
        }

        throw new IllegalArgumentException("Not found policy with number: " + num);
    }

    public int getNumber() {
        return number;
    }
}
