package ru.yandex.solomon.alert.domain;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class NotificationChannelWithStatusOverride {
    private final String channelId;
    private final Set<EvaluationStatus.Code> notifyStatusOverride;

    public NotificationChannelWithStatusOverride(String channelId) {
        this(channelId, Set.of());
    }

    public NotificationChannelWithStatusOverride(String channelId, Set<EvaluationStatus.Code> notifyStatusOverride) {
        this.channelId = channelId;
        this.notifyStatusOverride = notifyStatusOverride;
    }

    public String getChannelId() {
        return channelId;
    }

    @Nullable
    public Set<EvaluationStatus.Code> getNotifyStatusOverride() {
        return notifyStatusOverride;
    }
}
