package ru.yandex.solomon.alert.domain;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum ResolvedEmptyPolicy {
    // Default policy is RESOLVED_EMPTY_NO_DATA both for expression and threshold alerts.
    DEFAULT(ru.yandex.solomon.alert.protobuf.ResolvedEmptyPolicy.RESOLVED_EMPTY_DEFAULT.getNumber()),
    // If any of the selectors resolves to nothing, trigger OK immediately.
    OK(ru.yandex.solomon.alert.protobuf.ResolvedEmptyPolicy.RESOLVED_EMPTY_OK.getNumber()),
    // If any of the selectors resolves to nothing, trigger WARN immediately.
    WARN(ru.yandex.solomon.alert.protobuf.ResolvedEmptyPolicy.RESOLVED_EMPTY_WARN.getNumber()),
    // If any of the selectors resolves to nothing, trigger ALARM immediately.
    ALARM(ru.yandex.solomon.alert.protobuf.ResolvedEmptyPolicy.RESOLVED_EMPTY_ALARM.getNumber()),
    // If any of the selectors resolves to nothing, trigger NO_DATA immediately.
    NO_DATA(ru.yandex.solomon.alert.protobuf.ResolvedEmptyPolicy.RESOLVED_EMPTY_NO_DATA.getNumber()),
    // For expression alert return empty vector. Unsupported for threshold alerts.
    MANUAL(ru.yandex.solomon.alert.protobuf.ResolvedEmptyPolicy.RESOLVED_EMPTY_MANUAL.getNumber()),
    ;

    private final int number;

    ResolvedEmptyPolicy(int number) {
        this.number = number;
    }

    public static ResolvedEmptyPolicy forNumber(int num) {
        for (ResolvedEmptyPolicy policy : values()) {
            if (policy.getNumber() == num) {
                return policy;
            }
        }

        throw new IllegalArgumentException("Not found policy with number: " + num);
    }

    public int getNumber() {
        return number;
    }
}
