package ru.yandex.solomon.alert.domain.threshold;

/**
 * @author Vladimir Gordiychuk
 */
public enum Compare {
    /**
     * Equal the specified value
     */
    EQ(0),

    /**
     * Not equal the specified value
     */
    NE(1),

    /**
     * Greater than the specified value
     */
    GT(2),

    /**
     * Less than the specified value
     */
    LT(3),

    /**
     * Greater than or equal to the specified value
     */
    GTE(4),

    /**
     * Less than or equal to the specified value
     */
    LTE(5),

    ;

    private final int number;

    Compare(int number) {
        this.number = number;
    }

    public static Compare forNumber(int num) {
        for (Compare type : values()) {
            if (type.getNumber() == num) {
                return type;
            }
        }

        throw new IllegalArgumentException("Not found type with number: " + num);
    }

    public int getNumber() {
        return number;
    }
}
