package ru.yandex.solomon.alert.domain.threshold;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class FluentPredicate {
    public static FluentWhen when(ThresholdType thresholdType) {
        return new FluentWhen(thresholdType);
    }

    public static class FluentWhen {
        private final ThresholdType thresholdType;

        private FluentWhen(ThresholdType thresholdType) {
            this.thresholdType = thresholdType;
        }

        public FluentIs is(Compare compare) {
            return new FluentIs(thresholdType, compare);
        }
    }

    public static class FluentIs {
        private final ThresholdType thresholdType;
        private final Compare compare;

        private FluentIs(ThresholdType thresholdType, Compare compare) {
            this.thresholdType = thresholdType;
            this.compare = compare;
        }

        public FluentThan than(double value) {
            return new FluentThan(thresholdType, compare, value);
        }
    }

    public static class FluentThan {
        private final ThresholdType thresholdType;
        private final Compare compare;
        private final double value;

        private FluentThan(ThresholdType thresholdType, Compare compare, double value) {
            this.thresholdType = thresholdType;
            this.compare = compare;
            this.value = value;
        }

        public PredicateRule signal(TargetStatus status) {
            return PredicateRule.onThreshold(value).withComparison(compare).withThresholdType(thresholdType).withTargetStatus(status);
        }
    }
}
