package ru.yandex.solomon.alert.domain.threshold;

import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class PredicateStatusResult {
    private final boolean triggered;
    private final long timestamp;
    private final double value;

    public static final PredicateStatusResult NOT_TRIGGERED = new PredicateStatusResult(false, 0, Double.NaN);
    public static final PredicateStatusResult TRIGGERED = new PredicateStatusResult(true, 0, Double.NaN);

    public PredicateStatusResult withPoint(long ts, double val) {
        return new PredicateStatusResult(triggered, ts, val);
    }

    public long getTimestamp() {
        return timestamp;
    }

    public double getValue() {
        return value;
    }

    public boolean isTriggered() {
        return triggered;
    }

    public PredicateStatusResult(boolean triggered, long timestamp, double value) {
        this.triggered = triggered;
        this.timestamp = timestamp;
        this.value = value;
    }

    @Override
    public String toString() {
        return "PredicateStatusResult{" +
                "triggered=" + triggered +
                ", timestamp=" + Instant.ofEpochMilli(timestamp) +
                ", value=" + value +
                '}';
    }
}
