package ru.yandex.solomon.alert.domain.threshold;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum TargetStatus {
    OK(1),
    WARN(2),
    ALARM(3),
    NO_DATA(4),
    ;

    private final int number;

    TargetStatus(int number) {
        this.number = number;
    }

    public EvaluationStatus toEvaluationStatus() {
        switch (this) {
            case OK:
                return EvaluationStatus.OK;
            case WARN:
                return EvaluationStatus.WARN;
            case ALARM:
                return EvaluationStatus.ALARM;
            case NO_DATA:
                return EvaluationStatus.NO_DATA;
            default:
                return EvaluationStatus.ERROR.withDescription("Unmapped predicate target status " + toString());
        }
    }

    public static TargetStatus forNumber(int num) {
        for (TargetStatus type : values()) {
            if (type.getNumber() == num) {
                return type;
            }
        }

        throw new IllegalArgumentException("Not found target status with number: " + num);
    }

    public int getNumber() {
        return number;
    }

}
