package ru.yandex.solomon.alert.domain.threshold;

/**
 * @author Vladimir Gordiychuk
 */
public enum ThresholdType {
    AT_LEAST_ONE(0),
    AT_ALL_TIMES(1),
    LAST_NON_NAN(2),
    AVG(3),
    MIN(4),
    MAX(5),
    SUM(6),
    COUNT(7),
    ;

    private final int number;

    ThresholdType(int number) {
        this.number = number;
    }

    public static ThresholdType forNumber(int num) {
        for (ThresholdType type : values()) {
            if (type.getNumber() == num) {
                return type;
            }
        }

        throw new IllegalArgumentException("Not found type with number: " + num);
    }

    public int getNumber() {
        return number;
    }
}
