package ru.yandex.solomon.alert.evaluation;

/**
 * Different evaluation types are executed in separate queues and may have different options
 */
public enum AlertRuleExecutorType {
    DEFAULT(0),
    DATAPROXY(1),
    ;

    private final int number;

    public static AlertRuleExecutorType forNumber(int number) {
        for (var value : values()) {
            if (value.getNumber() == number) {
                return value;
            }
        }
        return DEFAULT;
    }

    public static AlertRuleExecutorType fromProto(ru.yandex.solomon.config.protobuf.alert.AlertRuleExecutorType type) {
        return forNumber(type.getNumber());
    }

    AlertRuleExecutorType(int number) {
        this.number = number;
    }

    public int getNumber() {
        return number;
    }

    public ru.yandex.solomon.config.protobuf.alert.AlertRuleExecutorType toProto() {
        return ru.yandex.solomon.config.protobuf.alert.AlertRuleExecutorType.forNumber(getNumber());
    }
}
