package ru.yandex.solomon.alert.evaluation;

import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.counters.AsyncMetrics;

/**
 * @author Vladimir Gordiychuk
 */
public class EvaluationLogsServiceMetrics {
    final GaugeInt64 queueSize;
    final AsyncMetrics save;
    final AsyncMetrics delete;

    public EvaluationLogsServiceMetrics(MetricRegistry registry) {
        this.queueSize = registry.gaugeInt64("evaluation.logs.queue.size");
        this.save = new AsyncMetrics(registry, "evaluation.logs.save.");
        this.delete = new AsyncMetrics(registry, "evaluation.logs.delete.ops.");
    }
}
