package ru.yandex.solomon.alert.evaluation;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.AlertKey;
import ru.yandex.solomon.alert.rule.EvaluationState;
import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
public interface EvaluationService {
    /**
     * Periodically evaluate alert and report evaluation state to consumer,
     * if alert was already assigned restart evaluation from provided state
     * @param alert alert to evaluate
     * @param state state for restart evaluation
     * @param consumer consume evaluation status until unassign or cancel, single consumer can be use
     *                 for consume multiple evaluation, for example pear project consumer
     */
    void assign(Alert alert, @Nullable EvaluationState state, Consumer consumer);

    /**
     * Cancel evaluation for particular alert
     */
    void unassign(AlertKey key);

    Statistics statistics();

    interface Consumer {
        /**
         * @return {@code true} consumer no more interested in evaluation status
         */
        boolean isCanceled();

        /**
         * Accept sequential evaluation state
         */
        void consume(@Nonnull EvaluationState state);

        /**
         * Execute when new evaluation not will be provided anymore
         */
        void onComplete();

        default AssignmentSeqNo getSeqNo() {
            return AssignmentSeqNo.EMPTY;
        }
    }

    record Statistics(int assignments, double evaluationRate) {
    }
}
