package ru.yandex.solomon.alert.evaluation;

import java.time.Clock;

import javax.annotation.Nullable;

import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.AlertKey;
import ru.yandex.solomon.alert.rule.AlertRule;
import ru.yandex.solomon.alert.rule.AlertRuleFactory;
import ru.yandex.solomon.alert.rule.EvaluationState;
import ru.yandex.solomon.alert.unroll.MultiAlertUnrollFactory;

/**
 * @author Vladimir Gordiychuk
 */
public class EvaluationServiceImpl implements EvaluationService {
    private final Clock clock;
    private final AlertRuleFactory ruleFactory;
    private final TaskExecutorDispatcher executorProvider;

    public EvaluationServiceImpl(
            Clock clock,
            AlertRuleFactory ruleFactory,
            TaskExecutorDispatcher executorProvider)
    {
        this.clock = clock;
        this.ruleFactory = ruleFactory;
        this.executorProvider = executorProvider;
    }

    @Override
    public void assign(Alert alert, @Nullable EvaluationState state, Consumer consumer) {
        if (MultiAlertUnrollFactory.isSupportUnrolling(alert)) {
            throw new IllegalArgumentException("Not able assign to evaluate multi alert: " + alert);
        }

        AlertRule rule = ruleFactory.createAlertRule(alert);

        executorProvider.createAndScheduleTask(rule, state, consumer);
    }

    @Override
    public void unassign(AlertKey key) {
        executorProvider.cancelTask(key);
    }

    @Override
    public Statistics statistics() {
        int assignments = executorProvider.getTaskCount();
        double evaluationRate = executorProvider.getTotalEvaluationRate();
        return new Statistics(assignments, evaluationRate);
    }
}
