package ru.yandex.solomon.alert.evaluation;

import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Vladimir Gordiychuk
 */
public class EvaluationStatusTemplateUtils {
    public static String statusToTemplateKey(EvaluationStatus.Code code) {
        switch (code) {
            case ERROR:
                return "isError";
            case OK:
                return "isOk";
            case WARN:
                return "isWarn";
            case ALARM:
                return "isAlarm";
            case NO_DATA:
                return "isNoData";
            default:
                throw new UnsupportedOperationException("Unsupported status code: " + code);
        }
    }
}
