package ru.yandex.solomon.alert.evaluation;

import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;

import ru.yandex.monlib.metrics.meter.ExpMovingAverage;
import ru.yandex.monlib.metrics.meter.Meter;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Executor-wide metrics
 * @author Vladimir Gordiychuk
 */
final class TaskExecutorMetrics {
    private final MetricRegistry registry;
    private final Rate evalActiveAlertOverflow;
    private final Meter evaluations = Meter.of(ExpMovingAverage.oneMinute());

    TaskExecutorMetrics(MetricRegistry registry) {
        this.registry = registry;
        this.evalActiveAlertOverflow = registry.rate("evaluations.eval.overflow");
    }

    public void lazyEvalInFlight(LongSupplier countActiveTask) {
        registry.lazyGaugeInt64("evaluations.eval.inFlight", countActiveTask);
    }

    public void lazyWarmupInFlight(LongSupplier countWarmupTask) {
        registry.lazyGaugeInt64("evaluations.warmup.inFlight", countWarmupTask);
    }

    public void lazyQueueSize(LongSupplier taskByAlertKeySize) {
        registry.lazyGaugeInt64("evaluations.queue.size", taskByAlertKeySize);
    }

    public void lazyWarmupQueueSize(LongSupplier warmupQueueSize) {
        registry.lazyGaugeInt64("evaluations.warmup.queue.size", warmupQueueSize);
    }

    public void lazyRegularQueueSize(LongSupplier queueSize) {
        registry.lazyGaugeInt64("evaluations.regular.queue.size", queueSize);
    }

    public void lazyQueueAvailableCapacity(LongSupplier availableCapacity) {
        registry.lazyGaugeInt64("evaluations.queue.available_capacity", availableCapacity);
    }

    void evalOverflow() {
        evalActiveAlertOverflow.inc();
    }

    public void markEvaluationCompleted() {
        evaluations.mark();
    }

    public double getEvaluationRate() {
        return evaluations.getRate(TimeUnit.SECONDS);
    }
}
