package ru.yandex.solomon.alert.evaluation;

/**
 * <p>{@link TaskExecutorState#PENDING} -> {@link TaskExecutorState#SCHEDULED}
 * <p>{@link TaskExecutorState#SCHEDULED} -> {@link TaskExecutorState#RUNNING}
 * <p>{@link TaskExecutorState#RUNNING} -> {@link TaskExecutorState#WAITING_QUOTA}
 * <p>{@link TaskExecutorState#RUNNING} -> {@link TaskExecutorState#PENDING}
 * <p>{@link TaskExecutorState#RUNNING} -> {@link TaskExecutorState#SCHEDULED}
 * <p>{@link TaskExecutorState#WAITING_QUOTA} -> {@link TaskExecutorState#SCHEDULED}
 *
 */
enum TaskExecutorState {
    /**
     * No alert assignments.
     */
    PENDING,

    /**
     * Scheduled next evaluation iteration, but still can be active background evaluation from
     * previous iteration.
     */
    SCHEDULED,

    /**
     * Starting alerts that should be evaluated in the current time.
     */
    RUNNING,

    /**
     * Already too many active alert evaluations
     */
    WAITING_QUOTA
}
