package ru.yandex.solomon.alert.executor.local;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.domain.Alert;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface AlertListener {
    /**
     * One of of alert parameter was changed on already assigned alert.
     */
    void alertChanged(Alert alert);

    /**
     * Now current application responsible by periodically evaluate current alert rule.
     */
    void assignAlert(Alert alert);

    /**
     * Remove responsibility for specified alert from the current application. It can means
     * that alert evaluation was move from current application to another one, or that alert
     * was deleted.
     */
    void unassignAlert(String alertId);
}
