package ru.yandex.solomon.alert.graph;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.domain.threshold.ThresholdAlert;
import ru.yandex.solomon.alert.rule.AlertTimeSeries;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface GraphLoader {
    CompletableFuture<List<AlertTimeSeries>> load(ThresholdAlert alert, Instant from, Instant to, Instant deadline);
}
