package ru.yandex.solomon.alert.graph;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import ru.yandex.solomon.alert.rule.AlertTimeSeries;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.GraphDataArrayList;
import ru.yandex.solomon.model.timeseries.MetricTypeTransfers;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNullableByDefault
public class Line {
    public String alias;
    public Map<String, String> labels;
    public MetricType dataType;
    public long[] timestampsMillis;
    public double[] values;
    public String status;
    public double value;

    private static boolean isConvertibleToDGauge(@Nonnull MetricType dataType) {
        return MetricTypeTransfers.isAvailableTransfer(dataType, MetricType.DGAUGE);
    }

    private static GraphDataArrayList graphDataArrayListOfSupported(@Nonnull AlertTimeSeries timeSeries) {
        var source = timeSeries.getSource();
        var dataType = timeSeries.getDataType();
        if (source.isEmpty()) {
            return new GraphDataArrayList();
        }
        return AggrGraphDataArrayList.of(source).toGraphDataArrayList(dataType);
    }

    public static Line of(@Nonnull AlertTimeSeries timeSeries) {
        AggrGraphDataIterable source = timeSeries.getSource();

        if (!source.isEmpty() && !isConvertibleToDGauge(timeSeries.getDataType())) {
            return null;
        }

        Line result = new Line();
        result.alias = timeSeries.getAlias();
        result.labels = timeSeries.getLabels().toMap();

        GraphDataArrayList arrayList = graphDataArrayListOfSupported(timeSeries);
        result.timestampsMillis = arrayList.getTimestamps();
        result.values = arrayList.getValues();
        return result;
    }
}
