package ru.yandex.solomon.alert.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;

import ru.yandex.solomon.alert.cluster.AlertingShardProxy;
import ru.yandex.solomon.alert.protobuf.TCreateNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TCreateNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TDeleteNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TDeleteNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TListEscalationsRequest;
import ru.yandex.solomon.alert.protobuf.TListEscalationsResponse;
import ru.yandex.solomon.alert.protobuf.TListNotificationsRequest;
import ru.yandex.solomon.alert.protobuf.TListNotificationsResponse;
import ru.yandex.solomon.alert.protobuf.TNotificationServiceGrpc;
import ru.yandex.solomon.alert.protobuf.TReadNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TResolveNotificationDetailsRequest;
import ru.yandex.solomon.alert.protobuf.TResolveNotificationDetailsResponse;
import ru.yandex.solomon.alert.protobuf.TUpdateNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TUpdateNotificationResponse;

import static ru.yandex.grpc.utils.StreamObservers.asyncComplete;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class GrpcNotificationService extends TNotificationServiceGrpc.TNotificationServiceImplBase {
    private final AlertingShardProxy proxy;

    // TODO: gather metrics (gordiychuk@)
    public GrpcNotificationService(AlertingShardProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void createNotification(TCreateNotificationRequest request, StreamObserver<TCreateNotificationResponse> responseObserver) {
        asyncComplete(proxy.createNotification(request), responseObserver);
    }

    @Override
    public void readNotification(TReadNotificationRequest request, StreamObserver<TReadNotificationResponse> responseObserver) {
        asyncComplete(proxy.readNotification(request), responseObserver);
    }

    @Override
    public void updateNotification(TUpdateNotificationRequest request, StreamObserver<TUpdateNotificationResponse> responseObserver) {
        asyncComplete(proxy.updateNotification(request), responseObserver);
    }

    @Override
    public void deleteNotification(TDeleteNotificationRequest request, StreamObserver<TDeleteNotificationResponse> responseObserver) {
        asyncComplete(proxy.deleteNotification(request), responseObserver);
    }

    @Override
    public void listNotifications(TListNotificationsRequest request, StreamObserver<TListNotificationsResponse> responseObserver) {
        asyncComplete(proxy.listNotification(request), responseObserver);
    }

    @Override
    public void resolveNotificationDetails(TResolveNotificationDetailsRequest request, StreamObserver<TResolveNotificationDetailsResponse> responseObserver) {
        asyncComplete(proxy.resolveNotificationDetails(request), responseObserver);
    }

    @Override
    public void listEscalations(TListEscalationsRequest request, StreamObserver<TListEscalationsResponse> responseObserver) {
        asyncComplete(proxy.listEscalations(request), responseObserver);
    }
}
