package ru.yandex.solomon.alert.grpc;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import io.grpc.stub.StreamObserver;

import ru.yandex.solomon.alert.notification.channel.telegram.ChatIdStorage;
import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;
import ru.yandex.solomon.alert.protobuf.TTelegramGroupTitlesRequest;
import ru.yandex.solomon.alert.protobuf.TTelegramGroupTitlesResponse;
import ru.yandex.solomon.alert.protobuf.TTelegramServiceGrpc;

import static java.util.concurrent.CompletableFuture.completedFuture;
import static ru.yandex.grpc.utils.StreamObservers.asyncComplete;


/**
 * @author alexlovkov
 **/
public class GrpcTelegramService extends TTelegramServiceGrpc.TTelegramServiceImplBase {

    private final ChatIdStorage chatIdStorage;

    public GrpcTelegramService(ChatIdStorage chatIdStorage) {
        this.chatIdStorage = chatIdStorage;
    }

    @Override
    public void telegramGroupTitles(
        TTelegramGroupTitlesRequest request, StreamObserver<TTelegramGroupTitlesResponse> responseObserver)
    {
        List<String> groupTitles = chatIdStorage.listGroups();

        CompletableFuture<TTelegramGroupTitlesResponse> response =
            completedFuture(TTelegramGroupTitlesResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .addAllGroupTitle(groupTitles)
                .build());

        asyncComplete(response, responseObserver);
    }
}
