package ru.yandex.solomon.alert.grpc;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import io.grpc.stub.StreamObserver;

import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;
import ru.yandex.solomon.alert.protobuf.TYaChatsGroupInfo;
import ru.yandex.solomon.alert.protobuf.TYaChatsGroupsRequest;
import ru.yandex.solomon.alert.protobuf.TYaChatsGroupsResponse;
import ru.yandex.solomon.alert.protobuf.TYaChatsServiceGrpc;
import ru.yandex.solomon.alert.yachats.YaChatsClient;

import static ru.yandex.grpc.utils.StreamObservers.asyncComplete;

/**
 * @author Nikita Minin
 */
public class GrpcYaChatsService extends TYaChatsServiceGrpc.TYaChatsServiceImplBase {

    private final YaChatsClient yaChatsClient;

    public GrpcYaChatsService(YaChatsClient yaChatsClient) {
        this.yaChatsClient = yaChatsClient;
    }

    @Override
    public void yaChatsGroups(
        TYaChatsGroupsRequest request, StreamObserver<TYaChatsGroupsResponse> responseObserver)
    {
        CompletableFuture<List<YaChatsClient.GroupsInfo>> getChatsCall = yaChatsClient.getChats();

        CompletableFuture<TYaChatsGroupsResponse> response =
            getChatsCall.thenApply(groups ->
                TYaChatsGroupsResponse.newBuilder()
                    .setRequestStatus(ERequestStatusCode.OK)
                    .addAllGroups(groups.stream().map(x -> TYaChatsGroupInfo.newBuilder()
                        .setTitle(x.getTitle())
                        .setDescription(x.getDescription())
                        .setId(x.getId())
                        .build()
                    ).collect(Collectors.toList()))
                    .build()
            );

        asyncComplete(response, responseObserver);
    }
}
