package ru.yandex.solomon.alert.inject.spring;

import java.time.Clock;
import java.util.concurrent.ScheduledExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.cluster.broker.alert.activity.TemplateAlertFactory;
import ru.yandex.solomon.alert.domain.AlertingLabelsAllocator;
import ru.yandex.solomon.alert.template.TemplateFactory;
import ru.yandex.solomon.config.protobuf.TKikimrClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.expression.ExpressionMetrics;
import ru.yandex.solomon.locks.DistributedLock;
import ru.yandex.solomon.locks.LockService;
import ru.yandex.solomon.locks.LockServiceImpl;
import ru.yandex.solomon.locks.dao.LocksDao;
import ru.yandex.solomon.util.host.HostUtils;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class AlertingContext {

    @Bean
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    public LockService lockService(LocksDao locksDao, ThreadPoolProvider threadpool, Clock clock, MetricRegistry registry) {
        ScheduledExecutorService executorService = threadpool.getSchedulerExecutorService();
        return new LockServiceImpl(HostUtils.getFqdn(), locksDao, clock, executorService, registry);
    }

    @Bean
    public DistributedLock distributedLock(LockService lockService) {
        return lockService.distributedLock("Leader");
    }

    @Bean
    public LabelAllocator labelAllocator() {
        return AlertingLabelsAllocator.I;
    }

    @Bean(name = "CrossDcKikimrClientConfig")
    public TKikimrClientConfig crossDcKikimrClient(TKikimrClientConfig config) {
        return config;
    }

    @Bean
    public ExpressionMetrics expressionMetrics() {
        return ExpressionMetrics.I;
    }

    @Bean
    public TemplateAlertFactory templateAlertFactory(TemplateFactory templateFactory) {
        return new TemplateAlertFactory(templateFactory);
    }
}
