package ru.yandex.solomon.alert.inject.spring;

import java.time.Clock;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.alert.cluster.AlertingShardProxy;
import ru.yandex.solomon.alert.cluster.balancer.AlertingBalancer;
import ru.yandex.solomon.alert.cluster.balancer.AlertingLocalShards;
import ru.yandex.solomon.alert.cluster.broker.alert.activity.TemplateAlertFactory;
import ru.yandex.solomon.alert.cluster.server.grpc.GrpcAlertingClusterService;
import ru.yandex.solomon.alert.cluster.server.grpc.GrpcBalancerService;
import ru.yandex.solomon.alert.cluster.server.grpc.GrpcEvaluationService;
import ru.yandex.solomon.alert.dao.AlertTemplateDao;
import ru.yandex.solomon.alert.dao.AlertTemplateLastVersionDao;
import ru.yandex.solomon.alert.evaluation.EvaluationExplainService;
import ru.yandex.solomon.alert.evaluation.LocalEvaluationExplainService;
import ru.yandex.solomon.alert.grpc.GrpcAlertService;
import ru.yandex.solomon.alert.grpc.GrpcAlertTemplateService;
import ru.yandex.solomon.alert.grpc.GrpcMuteService;
import ru.yandex.solomon.alert.grpc.GrpcNotificationService;
import ru.yandex.solomon.alert.grpc.GrpcTelegramService;
import ru.yandex.solomon.alert.grpc.GrpcYaChatsService;
import ru.yandex.solomon.alert.inject.spring.notification.YaChatsCondition;
import ru.yandex.solomon.alert.notification.channel.telegram.ChatIdStorage;
import ru.yandex.solomon.alert.rule.AlertRuleFactory;
import ru.yandex.solomon.alert.template.AlertTemplateService;
import ru.yandex.solomon.alert.template.AlertTemplateServiceImpl;
import ru.yandex.solomon.alert.unroll.MultiAlertUnrollFactory;
import ru.yandex.solomon.alert.yachats.YaChatsClient;
import ru.yandex.solomon.scheduler.TaskScheduler;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class AlertingGrpcServiceContext {

    @Bean
    public GrpcAlertingClusterService grpcAlertingClusterService(
            AlertingBalancer balancer,
            AlertingLocalShards localShards,
            GrpcEvaluationService grpcEvaluationService)
    {
        return new GrpcAlertingClusterService(balancer, localShards, grpcEvaluationService);
    }

    @Bean
    public GrpcBalancerService grpcBalancerService(AlertingLocalShards localShards, Clock clock) {
        return new GrpcBalancerService(localShards, clock);
    }

    @Bean
    public GrpcBalancerService.Proxy grpcBalancerServiceProxy(GrpcBalancerService service) {
        return service.createProxy();
    }

    @Bean
    public EvaluationExplainService evaluationExplainService(
            AlertingShardProxy proxy,
            AlertRuleFactory rule,
            MultiAlertUnrollFactory unroll,
            AlertTemplateDao cachedAlertTemplateDao,
            TemplateAlertFactory templateAlertFactory)
    {
        return new LocalEvaluationExplainService(proxy, rule, unroll, cachedAlertTemplateDao, templateAlertFactory);
    }

    @Bean
    public GrpcAlertService grpcAlertService(AlertingShardProxy proxy, EvaluationExplainService explainService) {
        return new GrpcAlertService(proxy, explainService);
    }

    @Bean
    public GrpcNotificationService grpcNotificationService(AlertingShardProxy proxy) {
        return new GrpcNotificationService(proxy);
    }

    @Bean
    public GrpcMuteService grpcMuteService(AlertingShardProxy proxy) {
        return new GrpcMuteService(proxy);
    }

    @Bean
    public AlertTemplateService alertTemplateService(
            AlertTemplateDao alertTemplateDao,
            AlertTemplateLastVersionDao alertTemplateLastVersionDao,
            TaskScheduler taskScheduler,
            Clock clock)
    {
        return new AlertTemplateServiceImpl(alertTemplateDao, alertTemplateLastVersionDao, taskScheduler, clock);
    }

    @Bean
    public GrpcAlertTemplateService grpcAlertTemplateService(AlertTemplateService alertTemplateService) {
        return new GrpcAlertTemplateService(alertTemplateService);
    }

    @Bean
    public GrpcTelegramService grpcTelegramService(ChatIdStorage chatIdStorage) {
        return new GrpcTelegramService(chatIdStorage);
    }

    @Bean
    @Conditional(YaChatsCondition.class)
    public GrpcYaChatsService grpcYaChatsService(YaChatsClient yaChatsClient) {
        return new GrpcYaChatsService(yaChatsClient);
    }
}
