package ru.yandex.solomon.alert.inject.spring;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.idempotency.IdempotentOperationContext;

/**
 * @author Alexey Trushkin
 */
@Configuration
public class AlertingIdempotentOperationContext extends IdempotentOperationContext {

    public static final String PATH = "/Alerting/V1/IdempotentOperation";

    public AlertingIdempotentOperationContext(
            @Qualifier("globalTableClient") TableClient tableClient,
            @Qualifier("globalSchemeClient") SchemeClient schemeClient,
            @Qualifier("configKikimrRootPath") String rootPath)
    {
        super(rootPath + PATH, tableClient, schemeClient);
    }
}
