package ru.yandex.solomon.alert.inject.spring;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.alert.client.AlertApi;
import ru.yandex.solomon.alert.dao.ProjectsHolder;
import ru.yandex.solomon.alert.tasks.PublishAlertTemplateTaskHandler;
import ru.yandex.solomon.config.protobuf.TKikimrClientConfig;
import ru.yandex.solomon.config.protobuf.TaskSchedulerConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.scheduler.context.TaskSchedulerContext;
import ru.yandex.solomon.spring.ConditionalOnBean;

/**
 * @author Alexey Trushkin
 */
@Configuration
@ConditionalOnBean(TaskSchedulerConfig.class)
public class AlertingSchedulerContext extends TaskSchedulerContext {

    public AlertingSchedulerContext(
            @Qualifier("globalTableClient") TableClient tableClient,
            @Qualifier("globalSchemeClient") SchemeClient schemeClient,
            @Qualifier("CrossDcKikimrClientConfig") TKikimrClientConfig ydbConfig,
            TaskSchedulerConfig schedulerConfig,
            ThreadPoolProvider threads)
    {
        super(ydbConfig.getSchemaRoot() + "/Alerting/V1", schedulerConfig, threads, tableClient, schemeClient);
    }

    @Bean
    public PublishAlertTemplateTaskHandler publishAlertTemplateTaskHandler(AlertApi alertApi, ProjectsHolder projectsHolder) {
        return new PublishAlertTemplateTaskHandler(alertApi, projectsHolder, executor());
    }
}
