package ru.yandex.solomon.alert.inject.spring;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;

import ru.yandex.ambry.AmbryClient;
import ru.yandex.ambry.HttpAmbryClient;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.ambry.AmbryPoller;
import ru.yandex.solomon.alert.client.AlertApi;
import ru.yandex.solomon.config.protobuf.AmbryClientConfig;
import ru.yandex.solomon.config.protobuf.alert.TAlertingConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.conf.flags.FeatureFlagsContext;
import ru.yandex.solomon.flags.FeatureFlagsHolder;
import ru.yandex.solomon.locks.DistributedLock;

/**
 * @author Ivan Tsybulin
 */
@Configuration
@Import({
        FeatureFlagsContext.class
})
public class AmbryPollerContext {
    private final ThreadPoolProvider threadPoolProvider;
    private final MetricRegistry registry;

    private final AmbryClientConfig config;

    public AmbryPollerContext(ThreadPoolProvider threadPoolProvider, MetricRegistry registry, Optional<AmbryClientConfig> maybeConfig) {
        this.threadPoolProvider = threadPoolProvider;
        this.registry = registry;
        this.config = maybeConfig.orElse(AmbryClientConfig.getDefaultInstance());
    }

    @Bean
    @Conditional(AmbryCondition.class)
    public AmbryClient ambryClient() {
        String url = config.getUrl();
        String poolName = config.getThreadPoolName();
        return new HttpAmbryClient(url, registry, threadPoolProvider.getExecutorService(poolName, ""));
    }

    @Bean
    @Conditional(AmbryCondition.class)
    public AmbryPoller ambryPoller(
            MetricRegistry registry,
            FeatureFlagsHolder featureFlagsHolder,
            AlertApi alertApi,
            AmbryClient ambryClient,
            ThreadPoolProvider threadPoolProvider,
            DistributedLock lock)
    {
        ScheduledExecutorService executorService = threadPoolProvider.getSchedulerExecutorService();
        String yasmItypeProjectPreifx = config.getYasmItypeProjectPrefix().isEmpty() ? "yasm_" : config.getYasmItypeProjectPrefix();
        return new AmbryPoller(registry, featureFlagsHolder, yasmItypeProjectPreifx, alertApi, ambryClient, executorService, lock);
    }

    private static class AmbryCondition implements Condition {
        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            var config = context.getBeanFactory().getBean(TAlertingConfig.class);
            if (!config.hasAmbryClientConfig()) {
                return false;
            }
            return !config.getAmbryClientConfig().getUrl().isEmpty();
        }
    }
}
