package ru.yandex.solomon.alert.inject.spring;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import ru.yandex.solomon.config.protobuf.alert.TAlertingConfig;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class CloudChannelCondition implements Condition {
    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        // Cloud channels work only if IAM authorization is enabled
        var authConfig = context.getBeanFactory().getBean(TAlertingConfig.class).getAuthConfig();
        return authConfig.hasIamConfig();
    }
}
