package ru.yandex.solomon.alert.inject.spring;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import yandex.cloud.auth.api.AsyncCloudAuthClient;

import ru.yandex.solomon.alert.graph.GraphLoader;
import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.cloud.CloudAuthClient;
import ru.yandex.solomon.alert.notification.channel.cloud.NotifyClient;
import ru.yandex.solomon.alert.notification.channel.cloud.email.CloudEmailNotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.cloud.push.CloudPushNotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.cloud.sms.CloudSmsNotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.cloud.sms.UrlShortener;

/**
 * @author Ivan Tsybulin
 */
@Conditional(CloudChannelCondition.class)
public class CloudChannelsContext {

    @Bean
    public CloudAuthClient cloudAuthClientForChannels(AsyncCloudAuthClient cloudAuthClient) {
        return new CloudAuthClient(cloudAuthClient);
    }

    @Bean
    public CloudEmailNotificationChannelFactory cloudEmailNotificationChannelFactory(
            NotifyClient notifyClient,
            CloudAuthClient authClient,
            GraphLoader graphLoader)
    {
        return new CloudEmailNotificationChannelFactory(notifyClient, authClient, graphLoader);
    }

    @Bean
    public CloudSmsNotificationChannelFactory cloudSmsNotificationChannelFactory(
            NotifyClient notifyClient,
            CloudAuthClient authClient,
            UrlShortener urlShortener,
            TemplateVarsFactory templateVarsFactory)
    {
        return new CloudSmsNotificationChannelFactory(notifyClient, authClient, urlShortener, templateVarsFactory);
    }

    @Bean
    public CloudPushNotificationChannelFactory cloudPushNotificationChannelFactory(
            NotifyClient notifyClient,
            CloudAuthClient authClient)
    {
        return new CloudPushNotificationChannelFactory(notifyClient, authClient);
    }
}
