package ru.yandex.solomon.alert.inject.spring;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;

import ru.yandex.solomon.alert.graph.GraphLoader;
import ru.yandex.solomon.alert.notification.channel.cloud.NotifyClient;
import ru.yandex.solomon.alert.notification.channel.datalens.DatalensEmailNotificationChannelFactory;
import ru.yandex.solomon.config.protobuf.alert.TNotifyConfig;
import ru.yandex.solomon.spring.ConditionalOnBean;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
@ConditionalOnBean(TNotifyConfig.class)
public class DatalensEmailContext {
    @Bean
    public DatalensEmailNotificationChannelFactory datalensEmailNotificationChannelFactory(
            NotifyClient notifyClient,
            GraphLoader graphLoader)
    {
        return new DatalensEmailNotificationChannelFactory(notifyClient, graphLoader);
    }
}
