package ru.yandex.solomon.alert.inject.spring;

import java.time.Duration;

import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.config.thread.ThreadPoolProvider;

import static ru.yandex.solomon.config.OptionalSet.setNonNull;

/**
 * @author Ivan Tsybulin
 */
@Configuration
public class DefaultHttpClientContext {
    @Bean
    public AsyncHttpClient httpClient(ThreadPoolProvider threadPoolProvider) {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();

        setNonNull(builder::setEventLoopGroup, threadPoolProvider.getIOExecutor());
        builder.setConnectTimeout(Math.toIntExact(Duration.ofSeconds(3).toMillis()));
        builder.setRequestTimeout(Math.toIntExact(Duration.ofSeconds(10).toMillis()));

        return new DefaultAsyncHttpClient(builder.build());
    }
}
