package ru.yandex.solomon.alert.inject.spring;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.cluster.AlertingHeartbeatProcess;
import ru.yandex.solomon.alert.cluster.balancer.AlertingLocalShards;
import ru.yandex.solomon.alert.cluster.health.ClusterMembershipChecker;
import ru.yandex.solomon.alert.cluster.health.ProjectReadinessChecker;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class HealthContext {
    private final MetricRegistry registry;

    public HealthContext(MetricRegistry registry) {
        this.registry = registry;
    }

    @Bean
    public ClusterMembershipChecker clusterMembership(AlertingHeartbeatProcess heartbeatProcess) {
        return new ClusterMembershipChecker(heartbeatProcess, registry);
    }

    @Bean
    public ProjectReadinessChecker projectReadinessChecker(AlertingLocalShards localShards) {
        return new ProjectReadinessChecker(localShards, registry);
    }
}
