package ru.yandex.solomon.alert.inject.spring;

import org.springframework.context.annotation.Bean;

import ru.yandex.cloud.token.IamTokenClient;
import ru.yandex.cloud.token.IamTokenClientOptions;
import ru.yandex.cloud.token.grpc.GrpcIamTokenClient;
import ru.yandex.solomon.config.protobuf.TIamTokenClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.spring.ConditionalOnBean;

/**
 * @author Vladimir Gordiychuk
 */
@ConditionalOnBean(TIamTokenClientConfig.class)
public class IamTokenClientContext {
    @Bean
    public IamTokenClient iamTokenClient(TIamTokenClientConfig config, ThreadPoolProvider threads) {
        var opts = IamTokenClientOptions.forAddress(config.getHost(), config.getPort())
                .withHandlerExecutor(threads.getExecutorService(config.getThreadPoolName(), "IamConfig.ThreadPoolName"))
                .withUserAgent("SolomonAlerting");
        return new GrpcIamTokenClient(opts);
    }
}
