package ru.yandex.solomon.alert.inject.spring;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.solomon.alert.cluster.balancer.AlertingLocalShards;
import ru.yandex.solomon.alert.inject.spring.rest.AlertingMetricsController;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.selfmon.GeneralMonitoringContext;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
@Import({
        GeneralMonitoringContext.class
})
public class MonitoringContext {
    @Bean
    public AlertingMetricsController registryController(
        ThreadPoolProvider threadPoolProvider,
        List<MetricSupplier> metrics,
        AlertingLocalShards localShards)
    {
        ScheduledExecutorService executorService = threadPoolProvider.getSchedulerExecutorService();
        return new AlertingMetricsController(metrics, localShards, executorService);
    }
}
