package ru.yandex.solomon.alert.inject.spring;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.cloud.auth.token.TokenProvider;
import ru.yandex.cluster.discovery.ClusterDiscoveryImpl;
import ru.yandex.discovery.DiscoveryService;
import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.grpc.conf.GrpcConfigurationContext;
import ru.yandex.grpc.utils.GrpcTransport;
import ru.yandex.passport.tvmauth.TvmClient;
import ru.yandex.solomon.config.protobuf.ProjectManagerConfig;
import ru.yandex.solomon.config.protobuf.rpc.TRpcClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.db.dao.client.GrpcProjectManagerLegacyClient;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
@Configuration
@Import({
        GrpcConfigurationContext.class
})
public class ProjectManagerClientContext {

    @Bean
    public GrpcProjectManagerLegacyClient projectManagerClient(
            @Qualifier("ProjectManagerClientConfig") Optional<TRpcClientConfig> rpcConfig,
            ThreadPoolProvider threadPoolProvider,
            Optional<ProjectManagerConfig> configOptional,
            @Qualifier("tvmClient") Optional<TvmClient> tvmClientOptional,
            @Qualifier("authContextIamTokenProvider") Optional<TokenProvider> iamTokenProvider,
            @Qualifier("ClientId") Optional<String> clientId,
            ClientOptionsFactory clientOptionsFactory)
    {
        if (configOptional.isEmpty() || rpcConfig.isEmpty()) {
            return null;
        }
        if (tvmClientOptional.isEmpty() && iamTokenProvider.isEmpty()) {
            return null;
        }
        var options = clientOptionsFactory.newBuilder(
                        "ProjectManagerClientConfig",
                        rpcConfig.get().getGrpcConfig())
                .setClientId(clientId.orElse("alerting"))
                .build();
        var executor = threadPoolProvider.getExecutorService("CpuLowPriority", "");
        var timer = threadPoolProvider.getSchedulerExecutorService();
        var discovery = new ClusterDiscoveryImpl<>(
                address -> new GrpcTransport(address, options),
                rpcConfig.get().getGrpcConfig().getAddressesList(),
                DiscoveryService.async(),
                timer,
                executor,
                TimeUnit.MINUTES.toMillis(20L));
        return new GrpcProjectManagerLegacyClient(discovery);
    }

}
