package ru.yandex.solomon.alert.inject.spring;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.notification.channel.sms.StaffUserPhoneProvider;
import ru.yandex.solomon.alert.notification.channel.sms.UserPhoneProvider;
import ru.yandex.solomon.config.protobuf.StaffClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.util.SolomonEnv;
import ru.yandex.staff.StaffClient;
import ru.yandex.staff.StaffClientOptions;
import ru.yandex.staff.StaffClients;

import static ru.yandex.solomon.config.OptionalSet.setString;
import static ru.yandex.solomon.config.OptionalSet.setTime;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class StaffClientContext {
    private static final Logger logger = LoggerFactory.getLogger(StaffClientContext.class);

    @Autowired
    private MetricRegistry registry;
    @Autowired(required = false)
    private StaffClientConfig config;
    @Autowired
    private SecretProvider secretProvider;

    @Bean
    @Nullable
    public StaffClient getStaffClient(ThreadPoolProvider threadPoolProvider) {
        if (config == null) {
            return null;
        }

        Optional<String> token = secretProvider.getSecret(config.getOAuthToken());
        if (SolomonEnv.DEVELOPMENT.isActive() && token.isEmpty()) {
            logger.warn("cannot create staff client without oauth token");
            return null;
        }

        StaffClientOptions.Builder opts = StaffClientOptions.newBuilder().setMetricRegistry(registry);
        setString(opts::setUrl, config.getUrl());
        setTime(opts::setCacheTtl, config.getCacheTtl());
        opts.setOauthToken(token.orElseThrow(() -> new RuntimeException("cannot create StaffClient without token")));
        opts.setExecutor(threadPoolProvider.getExecutorService("CpuLowPriority", ""));
        return StaffClients.create(opts.build());
    }

    @Bean
    public UserPhoneProvider getStaffUserPhoneProvider(Optional<StaffClient> client) {
        if (client.isEmpty()) {
            return login -> CompletableFuture.failedFuture(new UnsupportedOperationException("No configured used phone provider"));
        }

        return new StaffUserPhoneProvider(client.get());
    }
}
