package ru.yandex.solomon.alert.inject.spring;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

import com.google.common.io.Resources;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.alert.template.Template;
import ru.yandex.solomon.alert.template.TemplateFactory;

/**
 * @author Vladimir Gordiychuk
 */
public final class TemplateUtils {
    private TemplateUtils() {
    }

    public static Template makeTemplate(TemplateFactory templateFactory, String path, String defaultPath) throws IOException
    {
        if (!StringUtils.isEmpty(path)) {
            return templateFactory.createTemplateFromFile(path);
        } else {
            return makeTemplateAsResource(templateFactory, defaultPath);
        }
    }

    public static Template makeTemplateAsResource(TemplateFactory templateFactory, String defaultPath) throws IOException {
        URL resource = TemplateUtils.class.getResource(defaultPath);
        if (resource == null) {
            throw new NullPointerException(defaultPath);
        }
        String sourceCode = Resources.toString(resource, StandardCharsets.UTF_8);
        return templateFactory.createTemplate(sourceCode);
    }
}
