package ru.yandex.solomon.alert.inject.spring;

import java.util.Optional;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.abc.AbcClient;
import ru.yandex.solomon.alert.api.validators.NotificationValidator;
import ru.yandex.solomon.alert.inject.spring.notification.TelegramContext;
import ru.yandex.solomon.alert.notification.channel.telegram.ChatIdStorage;
import ru.yandex.staff.StaffClient;

/**
 * @author Ivan Tsybulin
 */
@Import({
    StaffClientContext.class,
    TelegramContext.class,
})
@Configuration
public class ValidatorsContext {
    @Bean
    public NotificationValidator notificationValidator(
            Optional<StaffClient> staffClient,
            Optional<ChatIdStorage> chatIdResolver,
            Optional<AbcClient> abcClient)
    {
        return new NotificationValidator(
                staffClient.orElse(null),
                chatIdResolver.orElse(null),
                abcClient.orElse(null)
        );
    }
}
