package ru.yandex.solomon.alert.inject.spring;

import org.asynchttpclient.AsyncHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.YasmsClientConfig;
import ru.yandex.yasms.YasmsClient;
import ru.yandex.yasms.YasmsClientOptions;
import ru.yandex.yasms.YasmsClients;

import static ru.yandex.solomon.config.OptionalSet.setString;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
@Import({
    DefaultHttpClientContext.class
})
public class YasmsClientContext {
    @Autowired
    private MetricRegistry registry;
    @Autowired(required = false)
    private YasmsClientConfig config;

    @Bean
    public YasmsClient yasmsClient(AsyncHttpClient httpClient) {
        if (config == null || YasmsClientConfig.getDefaultInstance().equals(config)) {
            return null;
        }

        YasmsClientOptions.Builder opts = YasmsClientOptions.newBuilder().setRegistry(registry);
        setString(opts::setAddress, config.getUrl());
        setString(opts::setSender, config.getSender());
        return YasmsClients.create(httpClient, opts.build());
    }
}
