package ru.yandex.solomon.alert.inject.spring.convert;

import javax.annotation.ParametersAreNonnullByDefault;

import org.asynchttpclient.DefaultAsyncHttpClientConfig;

import ru.yandex.solomon.config.protobuf.http.HttpClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;

import static ru.yandex.solomon.config.OptionalSet.setNonNull;
import static ru.yandex.solomon.config.OptionalSet.setString;
import static ru.yandex.solomon.config.OptionalSet.setTimeMillis;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public final class HttpClientConfigConverter {
    private HttpClientConfigConverter() {
    }

    public static DefaultAsyncHttpClientConfig fillConfig(HttpClientConfig proto, ThreadPoolProvider threadPoolProvider) {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();

        setString(builder::setUserAgent, proto.getUserAgent());
        setNonNull(builder::setEventLoopGroup, threadPoolProvider.getIOExecutor());
        setTimeMillis(builder::setConnectTimeout, proto.getConnectTimeout());
        setTimeMillis(builder::setRequestTimeout, proto.getRequestTimeout());

        builder.setUseInsecureTrustManager(proto.getSkipSslCertificateCheck());

        return builder.build();
    }
}
