package ru.yandex.solomon.alert.inject.spring.convert;

import ru.yandex.solomon.alert.notification.RetryOptions;
import ru.yandex.solomon.config.protobuf.RetryConfig;

import static ru.yandex.solomon.config.OptionalSet.setDouble;
import static ru.yandex.solomon.config.OptionalSet.setInt;
import static ru.yandex.solomon.config.OptionalSet.setTime;

/**
 * @author Vladimir Gordiychuk
 */
public final class RetryOptionsConverter {
    private RetryOptionsConverter() {
    }

    public static RetryOptions protoToOptions(RetryConfig config) {
        RetryOptions.Builder builder = RetryOptions.newBuilder();
        setInt(builder::setTaskRetryLimit, config.getTaskRetryLimit());
        setTime(builder::setInitialDelay, config.getInitialDelay());
        setTime(builder::setMaxRetryDelay, config.getMaxRetryDelay());
        setTime(builder::setTaskAgeLimit, config.getTaskAgeLimit());
        setDouble(builder::setRetryDelayMultiplier, config.getRetryDelayMultiplier());
        return builder.build();
    }
}
