package ru.yandex.solomon.alert.inject.spring.notification;

import java.util.Optional;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.alert.charts.ChartsClient;
import ru.yandex.solomon.alert.charts.ChartsClientImpl;
import ru.yandex.solomon.config.TimeConverter;
import ru.yandex.solomon.config.protobuf.alert.BrokerConfig;
import ru.yandex.solomon.config.protobuf.alert.TChartsClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.util.SolomonEnv;


/**
 * @author alexlovkov
 **/
@Configuration
public class ChartsContext {

    @Bean
    ChartsClient chartsClient(
            BrokerConfig config,
            ThreadPoolProvider threadPoolProvider,
            SecretProvider secretProvider)
    {
        TChartsClientConfig chartsConfig = config.getNotificationConfig().getChartsClientConfig();
        Optional<String> token = secretProvider.getSecret(chartsConfig.getToken());

        SolomonEnv env = SolomonEnv.current();
        if (SolomonEnv.DEVELOPMENT == env && token.isEmpty()) {
            // TODO: create stub client
            return new ChartsClientImpl(
                    threadPoolProvider.getIOExecutor(),
                    "",
                    env.id(),
                    TimeConverter.protoToDuration(chartsConfig.getRequestTimeout()));
        }

        return new ChartsClientImpl(
            threadPoolProvider.getIOExecutor(),
            token.orElseThrow(() -> new RuntimeException("cannot create ChartsClient without token")),
            env.id(),
            TimeConverter.protoToDuration(chartsConfig.getRequestTimeout()));
    }
}
