package ru.yandex.solomon.alert.inject.spring.notification;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.alert.notification.channel.fallback.FallbackNotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.telegram.TelegramNotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.yachats.YaChatsNotificationChannelFactory;
import ru.yandex.solomon.flags.FeatureFlagsHolder;

@ParametersAreNonnullByDefault
@Configuration
public class FallbackContext {
    @Bean
    @Conditional({TelegramCondition.class, YaChatsCondition.class})
    public FallbackNotificationChannelFactory fallbackNotificationChannelFactory(
            TelegramNotificationChannelFactory tgFactory,
            YaChatsNotificationChannelFactory ymFactory,
            FeatureFlagsHolder featureFlagsHolder)
    {
        return new FallbackNotificationChannelFactory(tgFactory, ymFactory, featureFlagsHolder);
    }
}
