package ru.yandex.solomon.alert.inject.spring.notification;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.template.MustacheTemplateFactory;
import ru.yandex.solomon.alert.template.TemplateFactory;
import ru.yandex.solomon.config.protobuf.alert.BrokerConfig;
import ru.yandex.solomon.config.protobuf.alert.NotificationConfig;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class GeneralContext {

    private final NotificationConfig config;

    public GeneralContext(BrokerConfig config) {
        this.config = config.getNotificationConfig();
    }

    @Bean
    public TemplateFactory templateFactory() {
        return new MustacheTemplateFactory();
    }

    @Bean
    public TemplateVarsFactory channelTemplateVarsFactory() {
        return new TemplateVarsFactory(config.getAddress(), config.getCloudAddress());
    }
}
