package ru.yandex.solomon.alert.inject.spring.notification;

import java.nio.file.Path;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.juggler.client.JugglerClient;
import ru.yandex.juggler.resolver.ProxyResolver;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.juggler.JugglerClients;
import ru.yandex.solomon.alert.notification.channel.juggler.JugglerNotificationChannelFactory;
import ru.yandex.solomon.alert.template.TemplateFactory;
import ru.yandex.solomon.config.protobuf.alert.BrokerConfig;
import ru.yandex.solomon.config.protobuf.alert.JugglerChannelConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.flags.FeatureFlagsHolder;
import ru.yandex.solomon.util.file.FileStorage;
import ru.yandex.solomon.util.file.SimpleFileStorage;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class JugglerContext {

    private static final Path CACHE_DIR = Path.of("cache");

    private final JugglerChannelConfig config;
    private final ExecutorService executor;
    private final ScheduledExecutorService timer;
    private final FileStorage storage;

    public JugglerContext(BrokerConfig config, ThreadPoolProvider threadPoolProvider) {
        this.config = config.getNotificationConfig().getJugglerConfig();
        this.executor = threadPoolProvider.getExecutorService(
                this.config.getThreadPoolName(), "JugglerChannelConfig.ThreadPoolName");
        this.timer = threadPoolProvider.getSchedulerExecutorService();
        this.storage = new SimpleFileStorage(CACHE_DIR);
    }

    @Bean
    public JugglerClient jugglerClient(MetricRegistry registry, FeatureFlagsHolder flagsHolder) {
        return JugglerClients.create(config, registry, executor, timer, flagsHolder);
    }

    @Bean
    public ProxyResolver proxyResolver(MetricRegistry registry, JugglerClient client) {
        return JugglerClients.makeProxyResolver(storage, client, config, registry, executor, timer);
    }

    @Bean
    public JugglerNotificationChannelFactory jugglerNotificationChannelFactory(
            Clock clock,
            JugglerClient client,
            TemplateFactory templateFactory,
            TemplateVarsFactory varsFactory)
    {
        return new JugglerNotificationChannelFactory(clock, client, templateFactory, varsFactory);
    }
}
