package ru.yandex.solomon.alert.inject.spring.notification;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.sms.SmsClient;
import ru.yandex.solomon.alert.notification.channel.sms.SmsClientImpl;
import ru.yandex.solomon.alert.notification.channel.sms.SmsNotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.sms.SmsTemplate;
import ru.yandex.solomon.alert.notification.channel.sms.UserPhoneProvider;
import ru.yandex.solomon.alert.template.TemplateFactory;
import ru.yandex.solomon.config.protobuf.alert.BrokerConfig;
import ru.yandex.solomon.config.protobuf.alert.SmsChannelConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.yasms.YasmsClient;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
@ParametersAreNonnullByDefault
public class SmsContext {
    private final SmsChannelConfig config;
    @WillNotClose
    private final ScheduledExecutorService notifyExecutor;

    public SmsContext(BrokerConfig config, ThreadPoolProvider threadPool) {
        this.config = config.getNotificationConfig().getSmsConfig();
        this.notifyExecutor = threadPool.getSchedulerExecutorService();
    }

    @Bean
    @Nullable
    public SmsClient smsClient(@Nullable YasmsClient yasmsClient, UserPhoneProvider userPhoneProvider) {
        if (yasmsClient == null) {
           return null;
        }

        return new SmsClientImpl(yasmsClient, userPhoneProvider);
    }

    @Bean
    public SmsTemplate defaultSmsTemplate(TemplateFactory templateFactory, TemplateVarsFactory vars) throws IOException {
        return SmsTemplate.create(templateFactory, vars);
    }

    @Bean
    @Nullable
    public SmsNotificationChannelFactory smsNotificationChannelFactory(
            @Nullable SmsClient smsClient,
            TemplateFactory templateFactory,
            SmsTemplate template)
    {
        if (smsClient == null) {
            return null;
        }

        int dailyLimit = config.getDailyPhoneLimit() > 0
                ? config.getDailyPhoneLimit()
                : 20;

        return new SmsNotificationChannelFactory(smsClient, notifyExecutor, templateFactory, template, dailyLimit);
    }
}

