package ru.yandex.solomon.alert.inject.spring.notification;

import java.io.IOException;

import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.webhook.WebhookNotificationChannelFactory;
import ru.yandex.solomon.alert.template.Template;
import ru.yandex.solomon.alert.template.TemplateFactory;
import ru.yandex.solomon.config.protobuf.alert.BrokerConfig;
import ru.yandex.solomon.config.protobuf.alert.WebhookChannelConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;

import static ru.yandex.solomon.alert.inject.spring.TemplateUtils.makeTemplate;
import static ru.yandex.solomon.alert.inject.spring.convert.HttpClientConfigConverter.fillConfig;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class WebhookContext {
    private static final String WEBHOOK_DEFAULT_CONTENT_TEMPLATE = "/ru/yandex/solomon/alert/notification/channel/template/webhook/defaultContentTemplate.mustache";
    private final WebhookChannelConfig config;

    public WebhookContext(BrokerConfig config) {
        this.config = config.getNotificationConfig().getWebhookConfig();
    }

    @Bean
    public AsyncHttpClient webhookHttpClient(ThreadPoolProvider threadPoolProvider) {
        return new DefaultAsyncHttpClient(fillConfig(config.getHttpClientConfig(), threadPoolProvider));
    }

    @Bean
    public WebhookNotificationChannelFactory webhookNotificationChannelFactory(
            @Qualifier("webhookHttpClient") AsyncHttpClient httpClient,
            TemplateFactory templateFactory,
            TemplateVarsFactory varsFactory) throws IOException
    {
        Template content = makeTemplate(templateFactory, config.getPathToContentTemplate(), WEBHOOK_DEFAULT_CONTENT_TEMPLATE);
        return new WebhookNotificationChannelFactory(httpClient, templateFactory, content, varsFactory);
    }
}
