package ru.yandex.solomon.alert.inject.spring.notification;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.yachats.YaChatsNotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.yachats.YaChatsRawLimits;
import ru.yandex.solomon.alert.notification.channel.yachats.YaChatsTemplate;
import ru.yandex.solomon.alert.template.TemplateFactory;
import ru.yandex.solomon.alert.yachats.YaChatsClient;
import ru.yandex.solomon.alert.yachats.YaChatsClientImpl;
import ru.yandex.solomon.config.protobuf.alert.BrokerConfig;
import ru.yandex.solomon.config.protobuf.alert.YaChatsChannelConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.util.SolomonEnv;

/**
 * @author Nikita Minin
 */
@Configuration
public class YaChatsContext {
    private final YaChatsChannelConfig config;
    private final ThreadPoolProvider threadPoolProvider;
    private final SecretProvider secretProvider;

    public YaChatsContext(BrokerConfig config, ThreadPoolProvider threadPoolProvider, SecretProvider secretProvider) {
        this.config = config.getNotificationConfig().getYaChatsConfig();
        this.threadPoolProvider = threadPoolProvider;
        this.secretProvider = secretProvider;
    }

    @Bean
    @Conditional(YaChatsCondition.class)
    public YaChatsClient yaChatsClient(MetricRegistry registry) {
        ExecutorService executor = threadPoolProvider
            .getExecutorService(config.getThreadPoolName(), "BrokerConfig.NotificationConfig.YaChatsConfig");

        Optional<String> token = secretProvider.getSecret(config.getToken());
        if (SolomonEnv.DEVELOPMENT.isActive() && token.isEmpty()) {
            // TODO: create stub client
            return new YaChatsClientImpl(config.getUrl().replaceAll("/\\z", ""), "", registry, executor);
        }

        return new YaChatsClientImpl(
                config.getUrl().replaceAll("/\\z", ""),
                token.orElseThrow(() -> new RuntimeException("cannot create YaChatsClient without token")),
                registry,
                executor);
    }

    @Bean
    @Conditional(YaChatsCondition.class)
    public YaChatsNotificationChannelFactory yaChatsNotificationChannelFactory(
        YaChatsClient client,
        TemplateFactory templateFactory,
        ThreadPoolProvider threadPoolProvider,
        TemplateVarsFactory vars) throws IOException
    {
        var template = YaChatsTemplate.create(templateFactory, vars);

        int generalRateLimit = config.getRateLimitEventsPerSecond() > 0
            ? config.getRateLimitEventsPerSecond()
            : 30;
        int rateLimitPerChat = config.getRateLimitEventsPerChat() > 0
            ? config.getRateLimitEventsPerChat()
            : 1;
        YaChatsRawLimits rawLimits = new YaChatsRawLimits(generalRateLimit, rateLimitPerChat);
        return new YaChatsNotificationChannelFactory(client,
            templateFactory, template, rawLimits,
            threadPoolProvider.getSchedulerExecutorService());
    }

    //todo chatIdResolver, UpdateReciver
}
