package ru.yandex.solomon.alert.mute.domain;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum MuteStatus {
    UNKNOWN(0),
    PENDING(1),
    ACTIVE(2),
    EXPIRED(3),
    ARCHIVED(4),
    ;

    private final int number;

    MuteStatus(int number) {
        this.number = number;
    }

    public static MuteStatus forNumber(int number) {
        for (var e : values()) {
            if (e.number == number) {
                return e;
            }
        }
        throw new IllegalArgumentException("Unknown mute status with number " + number);
    }
}
