package ru.yandex.solomon.alert.mute.domain;

import java.util.Arrays;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum MuteType {
    BY_SELECTORS(1),
    ;

    final int number;

    MuteType(int number) {
        this.number = number;
    }

    public int getNumber() {
        return number;
    }

    public static MuteType byNumber(int number) {
        return Arrays.stream(values())
                .filter(type -> type.getNumber() == number)
                .findFirst()
                .orElseThrow(() -> new IllegalArgumentException("Unknown mute type number: " + number));
    }
}
